<?php
require_once 'timezones_class.php';
require_once __DIR__ . '/../vendor/autoload.php';
$dotenv = Dotenv\Dotenv::createUnsafeImmutable(__DIR__ . '/../');
$dotenv->safeLoad();

class Db
{

    protected $p;
    public $dbh;

    public $carpeta = '';

    public function __construct()
    {
        $this->carpeta = $_ENV['CARPETA'] ?? '';

        if (!isset($this->dbh)) {

            $dbHost     = $_ENV['DB_HOST']     ?? "localhost";
            $dbUsername = $_ENV['DB_USERNAME'] ?? "tecnomediapos_food";
            $dbPassword = $_ENV['DB_PASSWORD'] ?? "$4&KbJ?skl~r";
            $dbName     = $_ENV['DB_DATABASE'] ?? "tecnomediapos_food";

            // Connect to the database
            try {
                date_default_timezone_set('America/Santiago');
                setlocale(LC_ALL, "es_VE.UTF-8", "es_VE", "esp");
                $conn = new PDO(
                    "mysql:host=$dbHost;dbname=$dbName",
                    $dbUsername,
                    $dbPassword,
                    array(
                        PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8",
                        PDO::ATTR_PERSISTENT => true
                    )
                );
                $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                $this->dbh = $conn;
            } catch (PDOException $e) {
                die("Failed to connect with MySQL: " . $e->getMessage());
            }
        }
    }
    public function SetNames()
    {
        return $this->dbh->query("SET NAMES 'utf8'");
    }
    ###### FIN DE CLASE #####
}
